/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of "Device/Open" dialog


  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxdeviceOpenDlg.h
///  Definition file of "Device/Open" dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "afxcmn.h"
#include "afxwin.h"
#include "cifXAPIlib.h"
#include <vector>

//forward declaration
class CCifXDeviceBase;

///////////////////////////////////////////////////////////////////////////////////////////
/// Device opening dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CCifxDeviceOpenDlg : public CDialog
{
  DECLARE_DYNAMIC(CCifxDeviceOpenDlg)

public:
  CCifxDeviceOpenDlg(CWnd* pParent = NULL);   // standard constructor
  virtual ~CCifxDeviceOpenDlg();
  void CCifxDeviceOpenDlg::AddDriverLib(CCifXAPIlib* pcCifxAPI)
  {
    m_pcvCifXAPI.push_back(pcCifxAPI);
  }


// Dialog Data
  enum { IDD = IDD_CHANNEL_SELECT };

protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
protected:
  CTreeCtrl         m_cDeviceTreeCtrl;      //!< Tree control for device display
  CListCtrl         m_cPropertyListCtrl;    //!< List control containing information about selected devices
  CCifXDeviceBase*  m_pcDevice;             //!< Pointer to the last selected device, only valid if used pressed OK
  std::vector<CCifXAPIlib*> m_pcvCifXAPI;

public:
  afx_msg void OnDestroy();
  afx_msg void OnTvnDeleteitemTreeDevices(NMHDR *pNMHDR, LRESULT *pResult);
  afx_msg void OnTvnSelchangedTreeDevices(NMHDR *pNMHDR, LRESULT *pResult);

  CCifXDeviceBase* GetSelectedDevice(void);
  afx_msg void OnBnClickedOk();
  afx_msg void OnNMDblclkTreeDevices(NMHDR *pNMHDR, LRESULT *pResult);
};
